import { Link, useLocation } from 'react-router-dom'
import { BookOpen } from 'lucide-react'
import Footer from './Footer'
import './Layout.css'

const Layout = ({ children }) => {
  const location = useLocation()

  return (
    <div className="app-wrapper">
      <header className="header">
        <div className="container">
          <div className="header-content">
            <Link to="/" className="logo">
              <BookOpen className="logo-icon" size={22} strokeWidth={1.5} />
              <span className="logo-text">Академия ЕГЭ</span>
            </Link>
            <nav className="nav">
              <Link 
                to="/" 
                className={`nav-link ${location.pathname === '/' ? 'active' : ''}`}
              >
                Мои курсы
              </Link>
              <Link 
                to="/enroll" 
                className={`nav-link ${location.pathname === '/enroll' ? 'active' : ''}`}
              >
                Записаться
              </Link>
            </nav>
          </div>
        </div>
      </header>

      <main className="main-content">
        {children}
      </main>

      <Footer />
    </div>
  )
}

export default Layout

